#!/usr/bin/env python3
import os, shutil, subprocess, sys
from datetime import datetime, timezone

def utc_ts() -> str:
    return datetime.now(timezone.utc).strftime("%Y-%m-%dT%H-%M-%SZ")

def main():
    here = os.path.dirname(os.path.abspath(__file__))
    engine = os.path.join(here, "engine_j27_tof_overlay.py")
    src_manifest = os.path.join(here, "J27_tof_overlay", "2025-11-06T23-03-08Z", "config", "manifest_j27.json")

    new_ts = utc_ts()
    outdir = os.path.join(here, "J27_tof_overlay", new_ts)
    cfgdir = os.path.join(outdir, "config")
    os.makedirs(cfgdir, exist_ok=True)

    shutil.copy2(src_manifest, os.path.join(cfgdir, "manifest_j27.json"))

    cmd = [sys.executable, engine, "--manifest", os.path.join(cfgdir, "manifest_j27.json"), "--outdir", outdir]
    print("Running:", " ".join(cmd))
    res = subprocess.run(cmd, cwd=here, text=True, capture_output=True)
    if res.stdout: print(res.stdout)
    if res.stderr: print(res.stderr, file=sys.stderr)

    rline = os.path.join(outdir, "outputs", "run_info", "result_line.txt")
    if os.path.exists(rline):
        with open(rline, "r", encoding="utf-8") as f:
            print("RESULT:", f.read().strip())
    else:
        print("No result_line.txt found; check logs.", file=sys.stderr)

if __name__ == "__main__":
    main()
